//=============================================================
// VisitorMain.cpp
// A demonstration of the Visitor design pattern in C++
// Author: Dr. Rick Coleman
//=============================================================
#pragma warning(disable:4996)

#include "CalorieCountVisitor.h"
#include "CarbCountVisitor.h"
#include "HealthRatingVisitor.h"
#include "Menu.h"
#include "MenuItem.h"
#include "Ingredient.h"
#include <stdio.h>
#include <iostream>
using namespace std;

// Function prototypes
void BuildMenus();

// Global vars -- Bad programmer no dessert for you!!!
vector<Menu *> m_vTheMenus;

void main()
{
	cout << "=== Demonstration of the Visitor Design Pattern ===\n\n";
	// Create some fake menus
	cout << "Building some menus for this demonstration...";
	BuildMenus();
	cout << "done.\n\n";
	cout << "Creating a Calorie Counting Visitor\n and telling it to visit each of the menus.\n\n";
	CalorieCountVisitor *calv = new CalorieCountVisitor();
	cout << "Press the Enter key to see the calorie information.\n";
	getchar();
	for(vector<Menu *>::iterator itr = m_vTheMenus.begin(); itr != m_vTheMenus.end(); itr++)
	{
		(*itr)->Accept(calv); // Must dereference this pointer to access the menu pointer
	}
	cout << endl << endl;
	cout << "\n\nCreating a Carb Counting Visitor\n and telling it to visit each of the menus.\n\n";
	CarbCountVisitor *carbv = new CarbCountVisitor();
	cout << "Press the Enter key to see the carbs information.\n";
	getchar();
	for(vector<Menu *>::iterator itr = m_vTheMenus.begin(); itr != m_vTheMenus.end(); itr++)
	{
		(*itr)->Accept(carbv); // Must dereference this pointer to access the menu pointer
	}

	cout << "\n\nCreating a Health Rating Visitor\n and telling it to visit each of the menus.\n\n";
	HealthRatingVisitor *hv = new HealthRatingVisitor();
	cout << "Press the Enter key to see the health rating information.\n";
	getchar();
	for(vector<Menu *>::iterator itr = m_vTheMenus.begin(); itr != m_vTheMenus.end(); itr++)
	{
		(*itr)->Accept(hv); // Must dereference this pointer to access the menu pointer
	}
	cout << endl << endl;
	cout << "\n\nPress enter to end this demonstation...";
	getchar();
}

//----------------------------------------
// Build 2 menus, each with 3 menu items
//   each with 1-3 ingredients.
// FYI:  The carbs and calories are close
//     to accurate and were found on the
//     web site www.carb-counter.net
//----------------------------------------
void BuildMenus()
{
	Menu *menu;
	MenuItem *menuItem;
	Ingredient *ingredient;

	// Create the first menu
	menu = new Menu();
	menu->setName("Objectville Pancake House");

	// Add MenuItem 1 to this Menu
	menuItem = new MenuItem();
	menuItem->setDescription("Stack of 3 pancakes with sausage and syrup.");
	menuItem->setName("Pancake Breakfast");
	menuItem->setPrice(3.95);
	menuItem->setVegetarian(false);
	// Add ingredients to this menu item
	ingredient = new Ingredient();
	ingredient->setName("Buttermilk Pancake");
	ingredient->setAmount(3.0);
	ingredient->setMeasure(UNIT);
	ingredient->setCarbs(22.10);
	ingredient->setCalories(175.0);
	menuItem->AddIngredient(ingredient);
	ingredient = new Ingredient();
	ingredient->setName("Sausage Patty");
	ingredient->setAmount(2.0);
	ingredient->setMeasure(OUNCE);
	ingredient->setCarbs(0.45);
	ingredient->setCalories(73.7);
	menuItem->AddIngredient(ingredient);
	ingredient = new Ingredient();
	ingredient->setName("Maple Syrup");
	ingredient->setAmount(4.0);
	ingredient->setMeasure(TABLESPOON);
	ingredient->setCarbs(12.96);
	ingredient->setCalories(52.2);
	menuItem->AddIngredient(ingredient);
	menu->AddItem(menuItem);

	// Add MenuItem 2 to this Menu
	menuItem = new MenuItem();
	menuItem->setDescription("Bacon and eggs with toast.");
	menuItem->setName("Big Breakfast");
	menuItem->setPrice(4.95);
	menuItem->setVegetarian(false);
	// Add ingredients to this menu item
	ingredient = new Ingredient();
	ingredient->setName("Bacon");
	ingredient->setAmount(2.0);
	ingredient->setMeasure(UNIT);
	ingredient->setCarbs(11.0);
	ingredient->setCalories(44.39);
	menuItem->AddIngredient(ingredient);
	ingredient = new Ingredient();
	ingredient->setName("Eggs");
	ingredient->setAmount(2.0);
	ingredient->setMeasure(UNIT);
	ingredient->setCarbs(0.40);
	ingredient->setCalories(92.5);
	menuItem->AddIngredient(ingredient);
	ingredient = new Ingredient();
	ingredient->setName("Toast");
	ingredient->setAmount(2.0);
	ingredient->setMeasure(UNIT);
	ingredient->setCarbs(12.65);
	ingredient->setCalories(66.5);
	menuItem->AddIngredient(ingredient);
	menu->AddItem(menuItem);

	// Add MenuItem 3 to this Menu
	menuItem = new MenuItem();
	menuItem->setDescription("Sweet roll with cream cheese frosting.");
	menuItem->setName("Sweet Breakfast");
	menuItem->setPrice(2.95);
	menuItem->setVegetarian(false);
	// Add ingredients to this menu item
	ingredient = new Ingredient();
	ingredient->setName("Sweet roll");
	ingredient->setAmount(2.0);
	ingredient->setMeasure(UNIT);
	ingredient->setCarbs(16.5);
	ingredient->setCalories(86.13);
	menuItem->AddIngredient(ingredient);
	ingredient = new Ingredient();
	ingredient->setName("Cream Cheese Frosting");
	ingredient->setAmount(2.0);
	ingredient->setMeasure(TABLESPOON);
	ingredient->setCarbs(15.76);
	ingredient->setCalories(99.6);
	menuItem->AddIngredient(ingredient);
	menu->AddItem(menuItem);
	// Add the menu to the vector
	m_vTheMenus.push_back(menu);

	// Create the second menu
	menu = new Menu();
	menu->setName("Objectville Cafe");
	// Add MenuItem 1 to this Menu
	menuItem = new MenuItem();
	menuItem->setDescription("Chicken fingers with fries and slaw.");
	menuItem->setName("Fingers and Fries Lunch");
	menuItem->setPrice(4.95);
	menuItem->setVegetarian(false);
	// Add ingredients to this menu item
	ingredient = new Ingredient();
	ingredient->setName("Fried Chicken Fingers");
	ingredient->setAmount(6.0);
	ingredient->setMeasure(UNIT);
	ingredient->setCarbs(4.2);
	ingredient->setCalories(121.3);
	menuItem->AddIngredient(ingredient);
	ingredient = new Ingredient();
	ingredient->setName("French Fries"); // Couldn't find FF so this is potato sticks
	ingredient->setAmount(4.0);
	ingredient->setMeasure(OUNCE);
	ingredient->setCarbs(14.72);
	ingredient->setCalories(147.99);
	menuItem->AddIngredient(ingredient);
	ingredient = new Ingredient();
	ingredient->setName("Cabbage Slaw");
	ingredient->setAmount(0.75);
	ingredient->setMeasure(CUP);
	ingredient->setCarbs(17.07);
	ingredient->setCalories(196.0);	
	menuItem->AddIngredient(ingredient);
	menu->AddItem(menuItem);

	// Add MenuItem 2 to this Menu
	menuItem = new MenuItem();
	menuItem->setDescription("Cheeseburger with fries.");
	menuItem->setName("Our Best Burger and Fries combo");
	menuItem->setPrice(4.95);
	menuItem->setVegetarian(false);
	// Add ingredients to this menu item
	ingredient = new Ingredient();
	ingredient->setName("Hamburger Patty");
	ingredient->setAmount(8.0);
	ingredient->setMeasure(OUNCE);
	ingredient->setCarbs(0.0);
	ingredient->setCalories(78.48);
	menuItem->AddIngredient(ingredient);
	ingredient = new Ingredient();
	ingredient->setName("Bun"); 
	ingredient->setAmount(1.0);
	ingredient->setMeasure(UNIT);
	ingredient->setCarbs(19.18);
	ingredient->setCalories(113.09);
	menuItem->AddIngredient(ingredient);
	ingredient = new Ingredient();
	ingredient->setName("Cheese Slice");
	ingredient->setAmount(1.0);
	ingredient->setMeasure(OUNCE);
	ingredient->setCarbs(0.36);
	ingredient->setCalories(112.84);
	menuItem->AddIngredient(ingredient);
	menu->AddItem(menuItem);
	ingredient = new Ingredient();
	ingredient->setName("French Fries"); // Couldn't find FF so this is potato sticks
	ingredient->setAmount(4.0);
	ingredient->setMeasure(OUNCE);
	ingredient->setCarbs(14.72);
	ingredient->setCalories(147.99);
	menuItem->AddIngredient(ingredient);

	// Add MenuItem 3 to this Menu
	menuItem = new MenuItem();
	menuItem->setDescription("8-ounce rib-eye with baked potato.");
	menuItem->setName("Rib-eye Dinner");
	menuItem->setPrice(6.95);
	menuItem->setVegetarian(false);
	// Add ingredients to this menu item
	ingredient = new Ingredient();
	ingredient->setName("Rib-eye steak");
	ingredient->setAmount(8.0);
	ingredient->setMeasure(OUNCE);
	ingredient->setCarbs(0.0);
	ingredient->setCalories(575.51);
	menuItem->AddIngredient(ingredient);
	ingredient = new Ingredient();
	ingredient->setName("Potato-baked"); 
	ingredient->setAmount(1.0);
	ingredient->setMeasure(UNIT);
	ingredient->setCarbs(36.59);
	ingredient->setCalories(160.89);
	menuItem->AddIngredient(ingredient);

	// Add the menu to the vector
	m_vTheMenus.push_back(menu);
}

// 
// Create MenuTraver which knows how to iterate through the composite
// Create Visitor parent class and HealthRatingVisitor subclass