//==========================================================================
// Visitor.h
// Parent class for all Visitors to demonstrate the Visitor Design Pattern.
// Author: Dr. Rick Coleman
//==========================================================================
#ifndef VISITOR_H
#define VISITOR_H

#include "Menu.h" 
#include "MenuItem.h"
#include "Ingredient.h"

class Visitor
{
	public:
		Visitor();								// Constructor
		~Visitor();								// Destructor
		// This function is to illustrate the Visitor Design Pattern
		virtual void Visit(Menu *menu);			// Visit this Menu
		virtual void Visit(MenuItem *item);		// Visit this MenuItem
		virtual void Visit(Ingredient *ing);	// Visit this Ingredient
};

#endif
