//==========================================================================
// Visitor.cpp
// Parent class for all Visitors to demonstrate the Visitor Design Pattern.
// Author: Dr. Rick Coleman
//==========================================================================
#include "Visitor.h" 

// Note: The visitor knows all about the items it will visit.  It adds functionality
//       to each without having to modify the items.

//--------------------------------------
// Constructor
//--------------------------------------
Visitor::Visitor()
{
}

//--------------------------------------
// Destructor
//--------------------------------------
Visitor::~Visitor()
{
}

//--------------------------------------
// Visit this Menu
//--------------------------------------
void Visitor::Visit(Menu *menu)
{
}

//--------------------------------------
// Visit this MenuItem
//--------------------------------------
void Visitor::Visit(MenuItem *item)
{
}

//--------------------------------------
// Visit this Ingredient
//--------------------------------------
void Visitor::Visit(Ingredient *ing)
{
}

