//========================================================================
// MenuItem.cpp
// Class for use in demonstrating the Visitor Design Pattern
// Author: Dr. Rick Coleman
//========================================================================
#pragma warning(disable:4996)

#include "MenuItem.h"
#include "Visitor.h"
#include <string>
#include <iostream>

using namespace std;

//--------------------------------------
// Constructor
//--------------------------------------
MenuItem::MenuItem()
{
	strcpy(m_sName, "Unknown");
	strcpy(m_sDesc, "Unknown");
	m_bVegetarian = false;
}

//--------------------------------------
// Destructor
//--------------------------------------
MenuItem::~MenuItem()
{
}
				
//--------------------------------------
// Set the name of this item
//--------------------------------------
void MenuItem::setName(char *name)
{
	strcpy(m_sName, name);
}
	
//--------------------------------------
// Get the name of this item
//--------------------------------------
char *MenuItem::getName()
{
	return m_sName;
}
		
//--------------------------------------
// Set the description of this item
//--------------------------------------
void MenuItem::setDescription(char *d)
{
	strcpy(m_sDesc, d);
}

//--------------------------------------
// Get the description of this item
//--------------------------------------
char *MenuItem::getDescription()
{
	return m_sDesc;
}

//--------------------------------------
// Set the price of this item
//--------------------------------------
void MenuItem::setPrice(double p)
{
	m_dPrice = p;
}

//--------------------------------------
// Get the price
//--------------------------------------
double MenuItem::getPrice()
{
	return m_dPrice;
}

//--------------------------------------
// Set vegetarian flag
//--------------------------------------
void MenuItem::setVegetarian(bool v)
{
	m_bVegetarian = v;
}

//--------------------------------------
// Return vegetarian flag
//--------------------------------------
bool MenuItem::isVegetarian()
{
	return m_bVegetarian;
}

//--------------------------------------
// Print this menu item
//--------------------------------------
void MenuItem::print()
{
	cout << "   " << m_sName << " - " << m_sDesc;
	if(m_bVegetarian)
		cout << " (Vegetarian)";
	cout << "    $" << m_dPrice << endl;
}

//--------------------------------------
// Accept this visitor and tell all
//    Ingredients to accept it.
//--------------------------------------
void MenuItem::Accept(Visitor *visitor)
{
	// Call the visitor for this MenuItem
	visitor->Visit(this);

	// Iterate through all ingredients and tell them to accept the visitor
	for(vector<Ingredient *>::iterator itr = m_vIngredients.begin(); itr != m_vIngredients.end(); itr++)
	{
		(*itr)->Accept(visitor); // Tell each ingredient to accept this visitor
	}
}

//--------------------------------------
// Add an ingredient to the vector
//--------------------------------------
void MenuItem::AddIngredient(Ingredient *ing)
{
	m_vIngredients.push_back(ing);
}

