//======================================================================
// Ingredient.h
// Class for use in demonstrating the Visitor Design Pattern.  Defines
//   the ingredients used in all MenuItems
// Author: Dr. Rick Coleman
//======================================================================
#ifndef INGREDIENT_H
#define INGREDIENT_H

class Visitor;

#include <vector>
using namespace std;

enum MEASURE {UNIT, CUP, TABLESPOON, TEASPOON, OUNCE};

class Ingredient
{
	private:
		char m_sName[32];
		double m_dAmount;		// Amount of this ingredient in the item
		MEASURE m_Measure;		// Cup, Tablespoon, Teaspoon, Ounce
		double m_dCarbs;		// Measure of the carbs in this ingredient
		double m_dCalories;		// Measure of the calories in this ingredient
		// Other items could be added here as needed

	public:
		Ingredient();						// Constructor
		~Ingredient();						// Destructor
		void setName(char *name);			// Set the name of this ingredient
		char *getName();					// Get the name of this ingredient
		void setAmount(double amount);		// Set the amount in this ingredient
		double getAmount();					// Get the amount
		void setMeasure(MEASURE measure);	// Set the measure used for this ingredient
		MEASURE getMeasure();				// Get the measure
		void setCarbs(double carbs);		// Set the carbs in this ingredient
		double getCarbs();					// Get the carbs
		void setCalories(double calories);	// Set the calories in this ingredient
		double getCalories();				// Get the calories
		// This function is to illustrate the Visitor Design Pattern
		void Accept(Visitor *v);			// Accept this visitor
};

#endif
