//==========================================================================
// CalorieCountVisitor.h
// Subclass of Visitor to demonstrate the Visitor Design Pattern.
// Author: Dr. Rick Coleman
//==========================================================================
#ifndef	CALORIECOUNTVISITOR_H
#define CALORIECOUNTVISITOR_H

#include "Visitor.h" 

class CalorieCountVisitor : public Visitor
{
	private:
		double m_dCCount;				// Running calorie count total for the current item

	public:
		CalorieCountVisitor();			// Constructor
		~CalorieCountVisitor();			// Destructor
		// This function is to illustrate the Visitor Design Pattern
		void Visit(Menu *menu);			// Visit this Menu
		void Visit(MenuItem *item);		// Visit this MenuItem
		void Visit(Ingredient *ing);	// Visit this Ingredient
};

#endif
