//=============================================================
// PrototypeMain.cpp
// A demonstration of the Prototye design pattern in C++
// Author: Dr. Rick Coleman
//=============================================================
#pragma warning(disable:4996)

#include "MonsterRegistry.h"
#include <windows.h>  // for the Sleep() function
#include <conio.h>
#include <iostream>
using namespace std;

void main()
{
	Monster *m;

	cout << "=== Demonstration of the Prototype Design Pattern ===\n\n";
	cout << "Creating a MonsterRegistry for a game of Dungeons and Dragons\n\n";
	MonsterRegistry *mReg = new MonsterRegistry();
	cout << "The Dungeons and Dragons game has begun.\n\n";

	Sleep(1000);
	cout << "The Dungeon Master is calling for a Fire Dragon.\n";
	m = mReg->getMonster("Fire Dragon");
	if(m != NULL)
		cout << "The monster is attacking...\n\n";
	else
		cout << "Oops! The MonsterRegistry failed to find a prototype for a Fire Dragon.\n";
	Sleep(1000);
	cout << "Congratulations!  You successfully defeated the Fire Dragon.\n\n";

	Sleep(1000);
	cout << "The Dungeon Master is calling for a Beholder.\n";
	m = mReg->getMonster("Beholder");
	if(m != NULL)
		cout << "The monster is attacking...\n\n";
	else
		cout << "Oops! The MonsterRegistry failed to find a prototype for a Beholder.\n";
	Sleep(1000);
	cout << "Congratulations!  You successfully defeated the Beholder.\n\n";

	Sleep(1000);
	cout << "The Dungeon Master is calling for a two Kobolds.\n";
	m = mReg->getMonster("Kobold");
	if(m != NULL)
		cout << "The monster is attacking...\n\n";
	else
		cout << "Oops! The MonsterRegistry failed to find a prototype for a Kobold.\n";

	m = mReg->getMonster("Kobold");
	if(m != NULL)
		cout << "The monster is attacking...\n\n";
	else
		cout << "Oops! The MonsterRegistry failed to find a prototype for a Kobold.\n";
	Sleep(1000);
	cout << "Congratulations!  You successfully defeated both Kobolds.\n\n";

	Sleep(1000);
	cout << "The Dungeon Master is calling for a Litch.\n";
	m = mReg->getMonster("Litch");
	if(m != NULL)
		cout << "The monster is attacking...\n\n";
	else
		cout << "Oops! The MonsterRegistry failed to find a prototype for a Beholder.\n";
	Sleep(1000);
	cout << "Aggggggg!  Death and destruction the Litch has destroyed your character.\n\n";

	Sleep(1000);
	cout << "Game over man...";
	cout << "\n\nPress enter to end this demonstation...";
	getchar();

}
