//==========================================================================
// MonsterRegistry.h
// This class takes care of creating all the prototype monsters and creating
//   clones of each for a game of dungeons and dragons.  This is used in the
//   demonstration of the Prototype Design Pattern.
// Author: Dr. Rick Coleman
//==========================================================================
#ifndef MONSTERREGISTRY_H
#define MONSTERREGISTRY_H

#include "Monster.h"
#include <vector>
using namespace std;

class MonsterRegistry
{
	private:
		vector<Monster *> m_vMonsterPrototypes;			// Prototypes of all monsters

	public:
		MonsterRegistry();					// Constructor
		~MonsterRegistry();					// Destructor
		Monster *getMonster(char *type);	// Clone a monster and return a pointer to it
};

#endif