//==========================================================================
// MonsterRegistry.cpp
// This class takes care of creating all the prototype monsters and creating
//   clones of each for a game of dungeons and dragons.  This is used in the
//   demonstration of the Prototype Design Pattern.
// Author: Dr. Rick Coleman
//==========================================================================
#include "MonsterRegistry.h"
#include "string.h"
#include <iostream>
using namespace std;

//--------------------------------------------
// Constructor - Creates all the monster
//   prototypes.
//--------------------------------------------
MonsterRegistry::MonsterRegistry()
{
	cout << "MonsterRegistry:  Creating prototypes of all monsters and adding them to the registry.";
	Monster *m;
	// Create all the prototypes Fire Dragon, Litch, Beholder, Kobold
	m = new Monster();
	m->setType("Fire Dragon");
	m->setHitPoints(350);
	m->setStrength(18);		// Max strength
	m->setDangerLevel(100); // Max danger
	m_vMonsterPrototypes.push_back(m);

	m = new Monster();
	m->setType("Litch");
	m->setHitPoints(400);
	m->setStrength(18);		// Max strength
	m->setDangerLevel(100); // Max danger
	m_vMonsterPrototypes.push_back(m);

	m = new Monster();
	m->setType("Beholder");
	m->setHitPoints(75);
	m->setStrength(15);		
	m->setDangerLevel(80); 
	m_vMonsterPrototypes.push_back(m);

	m = new Monster();
	m->setType("Kobold");
	m->setHitPoints(25);
	m->setStrength(12);		// Max strength
	m->setDangerLevel(25); // Max danger
	m_vMonsterPrototypes.push_back(m);
	cout << "...done\n\n";
}

//--------------------------------------------
// Destructor
//--------------------------------------------
MonsterRegistry::~MonsterRegistry()
{
	m_vMonsterPrototypes.clear();
}

//--------------------------------------------
// Clone a monster and return a pointer to it
//--------------------------------------------
Monster *MonsterRegistry::getMonster(char *type)
{
	Monster *m = NULL;

	for(vector<Monster *>::iterator itr = m_vMonsterPrototypes.begin(); itr != m_vMonsterPrototypes.end(); itr++)
	{
		if(strcmp(type, (*itr)->getType()) == 0)  
		{
			// Found it so clone this one.
			cout << "MonsterRegistry is cloning the " << type << " monster prototype.\n";
			m = (*itr)->Clone();
			return m;
		}
	}
	return NULL; // Didn't find the type
}

