//==========================================================================
// Monster.cpp
// This class defines the monsters.  It is a very simple version of a D&D
//		creature.
// Author: Dr. Rick Coleman
//==========================================================================
#pragma warning(disable:4996)

#include "Monster.h"
#include "string.h"

//--------------------------------------------
// Constructor
//--------------------------------------------
Monster::Monster()
{
	m_sType[0] = '\0';
	m_iHitPoints = 0;
	m_iStrength = 0;
	m_iDangerLevel = 0;
}

//--------------------------------------------
// Destructor
//--------------------------------------------
Monster::~Monster()
{
}

//--------------------------------------------
// Clone this monster
//--------------------------------------------
Monster *Monster::Clone()
{
	Monster *m = new Monster();
	m->setType(m_sType);
	m->setHitPoints(m_iHitPoints);
	m->setStrength(m_iStrength);
	m->setDangerLevel(m_iDangerLevel);
	return m;
}

//--------------------------------------------
// Set the type of monster
//--------------------------------------------
void Monster::setType(char *type)
{
	strcpy(m_sType, type);
}

//--------------------------------------------
// Get the type of monster
//--------------------------------------------
char *Monster::getType()
{
	return m_sType;
}

//--------------------------------------------
// Set the number of hit points
//--------------------------------------------
void Monster::setHitPoints(int hp)
{
	m_iHitPoints = hp;
}

//--------------------------------------------
// Get the number of hit points
//--------------------------------------------
int Monster::getHitPoints(int hp)
{
	return m_iHitPoints;
}

//--------------------------------------------
// Set the strength of this monster
//--------------------------------------------
void Monster::setStrength(int s)
{
	m_iStrength = s;
}

//--------------------------------------------
// Get the strength of this monster
//--------------------------------------------
int Monster::getStrength()
{
	return m_iStrength;
}

//--------------------------------------------
// Set the danger level of this monster
//--------------------------------------------
void Monster::setDangerLevel(int dl)
{
	m_iDangerLevel = dl;
}

//--------------------------------------------
// Get the danger level of this monster
//--------------------------------------------
int Monster::getDangerLevel()
{
	return m_iDangerLevel;
}
