//==========================================================================
// GameMemento.h
//  This class maintains the state of the game and when called on will save
//  the current state information to a file so it can be recovered if
//  necessary.
//  Author Dr. Rick Coleman
//==========================================================================
#ifndef GAMEMEMENTO_H
#define GAMEMEMENTO_H

class GameMemento
{
	//--- The data listed below is for demonstration ---
	//--- In a real application of the Memento you   ---
	//--- would define all variables needed to save  ---
	//--- the current state of the application.      ---
	private:
		char m_sPlayerData[81];			// Player's name 
		char m_sCreatureData[81];		// Creature's data
		char m_sTreasureData[81];		// Treasure items data
		char m_sGameScenarioData[81];	// Game scenario data 
		char m_sPlayerStateData[81];	// Player's current state
		int m_iStateFlag;				// State flag
		char m_sRecoveryFileName[32];	// Name of File to save recovery data to 

	public:
		GameMemento();					// Default constructor
		~GameMemento();					// Destructor
		void SetPlayerData(char *pd);
		void SetCreatureData(char *cd);
		void SetTreasureData(char *td);
		void SetGameScenarioData(char *gsd);
		void SetPlayerStateData(char *psd);
		void SetStateFlag(int sf);
		char *GetRecoveryFileName();
		void UpdateGameMemento();
};

#endif
