//==========================================================================
// GameMemento.cpp
//  This class maintains the state of the game and when called on will save
//  the current state information to a file so it can be recovered if
//  necessary.
//  Author Dr. Rick Coleman
//==========================================================================
#pragma warning(disable:4996)

#include "GameMemento.h"
#include <string.h>
#include <fstream>
using namespace std;

//--------------------------------------
// Default constructor
//--------------------------------------
GameMemento::GameMemento()
{
	// Set all data defaults
	strcpy(m_sPlayerData, "");
	strcpy(m_sCreatureData, "");
	strcpy(m_sTreasureData, "");
	strcpy(m_sGameScenarioData, "");
	strcpy(m_sPlayerStateData, "");
	m_iStateFlag = 0;
	strcpy(m_sRecoveryFileName, "MementoGameBackup.txt");
}

//--------------------------------------
// Destructor
//--------------------------------------
GameMemento::~GameMemento()
{
}

//--------------------------------------
// This function is called by Game to 
//   update the Player Data as needed.
//--------------------------------------
void GameMemento::SetPlayerData(char *pd)
{
	strcpy(m_sPlayerData, pd);
}

//--------------------------------------
//T his function is called by Game to 
//   update the Creature Data as needed.
//--------------------------------------
void GameMemento::SetCreatureData(char *cd)
{
	strcpy(m_sCreatureData, cd);
}

//--------------------------------------
// This function is called by Game to 
//   update the Treasure Data as needed.
//--------------------------------------
void GameMemento::SetTreasureData(char *td)
{
	strcpy(m_sTreasureData, td);
}

//--------------------------------------
// This function is called by Game to 
//   update the Game Scenario Data as 
//   needed.
//--------------------------------------
void GameMemento::SetGameScenarioData(char *gsd)
{
	strcpy(m_sGameScenarioData, gsd);
}

//--------------------------------------
// This function is called by Game to 
//   update the Player State Data as 
//   needed.
//--------------------------------------
void GameMemento::SetPlayerStateData(char *psd)
{
	strcpy(m_sPlayerStateData, psd);
}

//--------------------------------------
// This function is called by Game to 
//   update the Game State Flag as 
//   needed.
//--------------------------------------
void GameMemento::SetStateFlag(int sf)
{
	m_iStateFlag = sf;
}

//--------------------------------------
// Get the name of the saved file.
//--------------------------------------
char *GameMemento::GetRecoveryFileName()
{
	return m_sRecoveryFileName;
}

//--------------------------------------------------
// Update the current Memento.  In this function
//   all data needed to preserve the current state
//   of the game is collected.  Without violating
//   encapsulation the GameMemento is allowed to
//   collect needed data from the Game object. The
//   data is then saved to a backup file.
//-------------------------------------------------
void GameMemento::UpdateGameMemento()
{
	ofstream theFile;
	char line[81];
	
	 // Set up to write lines to the file
	theFile.open(m_sRecoveryFileName);
	// Build the lines and write them out to the file
	strcpy(line, "========= This file saves the state of the game when interrupted. =======");
	theFile.write(line, strlen(line));
	theFile.write("\n", 1); // Add a new line at the end

	// Write out all data 
	theFile.write(m_sPlayerData, strlen(m_sPlayerData));
	theFile.write("\n", 1); // Add a new line at the end
	theFile.write(m_sCreatureData, strlen(m_sCreatureData));
	theFile.write("\n", 1); // Add a new line at the end
	theFile.write(m_sTreasureData, strlen(m_sTreasureData));
	theFile.write("\n", 1); // Add a new line at the end
	theFile.write(m_sGameScenarioData, strlen(m_sGameScenarioData));
	theFile.write("\n", 1); // Add a new line at the end
	theFile.write(m_sPlayerStateData, strlen(m_sPlayerStateData));
	theFile.write("\n", 1); // Add a new line at the end
	sprintf(line, "Game minutes elapsed time = %d", m_iStateFlag);
	theFile.write(line, strlen(line));
	theFile.write("\n", 1); // Add a new line at the end
	strcpy(line, "===========================================================================");
	theFile.write(line, strlen(line));
	theFile.write("\n", 1); // Add a new line at the end

	theFile.close();
 }
