//==========================================================================
// Game.h
//  This class creates a simulated role playing game to demonstrate the
//  Memento Design Pattern.  At regular intervals a GameMemento object
//  is updated and saved to disk to preserve the last state of the game.
//  Author Dr. Rick Coleman 
//==========================================================================
#ifndef GAME_H
#define GAME_H

#include "GameMemento.h"
#include <fstream>
using namespace std;

// Define some game board dimensions
#define BOARDLEFT 0				// Board array left index min
#define BOARDTOP 0				// Board array top index min
#define BOARDRIGHT 29			// Board array right index max
#define BOARDBOTTOM 19			// Board array bottom index max
#define BOARDWIDTH 30			// Board array width
#define BOARDHEIGHT 20			// Board array height

class Game
{
	private: 
		GameMemento *m_GameMemento;		// The game memento object
		char m_GameBoard[BOARDHEIGHT][BOARDWIDTH];
	
	public: 
		Game();					// Constructor
		~Game();				// Destructor
		void PlayGame();		// Play the simulated game
		void SaveGameState(int state);	// Save the game state to disk.

	private: 
		int InitGame(char *backupFile); //Initialize the game.
		void PrintGameBoard(int X, int Y);
		void getNextLine(ifstream& inFile, char *line, int lineLen);
};

#endif
