//=========================================================
// Sprinkler.cpp
// This class defines a sub-class of Sprinkler for the 
//	Mediator Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#pragma warning(disable:4996)

#include "Sprinkler.h"
#include "HomeMediator.h"
#include <string.h>
#include <iostream>
using namespace std;

//----------------------------------
// Constructor
//----------------------------------
Sprinkler::Sprinkler(HomeMediator *mediator, char *name)
{
	m_TheMediator = mediator; // Set pointer to the mediator
	strcpy(m_sName, name);    // Save the Sprinkler name
	m_dTime = 0.0;			  // Start at midnight
}

//----------------------------------
// Destructor
//----------------------------------
Sprinkler::~Sprinkler()
{
	// Nothing to do.  Someone else destroys the mediator
}

//----------------------------------------------------
// Check to see if we need to send a message to the
//   mediator.
//----------------------------------------------------
void Sprinkler::checkStatus()
{
	// Nothing to do here we check on time/day messages
	//  relayed by the mediator from the clock and calendar
}

//----------------------------------------------------
// Pass a message to the mediator when it calls. This
//   message will be relayed to the other Sprinklers.
//----------------------------------------------------
char *Sprinkler::queryAppliance()
{
	int roundTime = (int)((m_dTime+0.05) * 10);
	if((roundTime >= 75) && (roundTime < 90))
	{
		// Prepare message - Note internal time is 30 off.  Why???
		if((roundTime >= 75) && (roundTime < 80))
			sprintf(m_sMessage, "SPRINKLER: Sprinkler is turning on.");
		else if(roundTime >= 85)
			sprintf(m_sMessage, "SPRINKLER: Sprinkler is turning off.");
		else
			sprintf(m_sMessage, "SPRINKLER: Sprinkler is running.");
	}
	return m_sMessage;
}

//----------------------------------------------------
// Mediator calls this function to pass in a message 
//  from the other appliances.
//----------------------------------------------------
void Sprinkler::updateAppliance(char *msg)
{
	// See if the message is a sprinkle on/off time.
	if((strstr(msg, "DAY") != NULL))
	{
		// We water on Monday, Wednesday, and Friday
		if((strstr(msg, "Monday") != NULL) || 
			(strstr(msg, "Wednesday") != NULL) ||
			(strstr(msg, "Friday") != NULL))
		{
			int roundTime = (int)((m_dTime+0.05) * 10);
			// Start watering at 8:00, end at 9:00
			// Note: The way the cycle runs the actual time here will
			//		always be one TIMESTEP behind the AlarmClock
			if((roundTime >= 75) && (roundTime < 90))
			{
				m_TheMediator->ApplianceHasMessage(this); // Tell the mediator we have a message
			}
		}
	}
}
