//=============================================================
// MediatorMain.cpp
// A demonstration of the Mediator design pattern in C++
// Author: Dr. Rick Coleman
//=============================================================
#pragma warning(disable:4996)

#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>     // needed for the _ftime() function
#include <sys/timeb.h>     // contains definition of _timeb struct
#include <time.h>          // needed for other time functions and structures
#include "HomeMediator.h"

using namespace std;
#define TIMESTEP 30

// SEE NOTES BELOW

void main()
{
	// Vars for running the sim
    struct _timeb   tStruct;
	double curTime = 0.0;  // Start at midnight
	double thisTime;
	double nextTime;
	bool done = false;

 	cout << "=== Demonstration of the Mediator Design Pattern ===\n\n";
	cout << "press ctrl-C to terminate the demonstration.\n\n";
	HomeMediator *hm = new HomeMediator();

	srand((unsigned int)(time(NULL))); // Seed the random number generator
	// Get current system time
	_ftime(&tStruct);
	thisTime = tStruct.time + (((double)(tStruct.millitm)) / 1000.0);
	nextTime = thisTime + 1.0;

	// Set up timer loop
	while(!done)
	{
		// Get current system time
		_ftime(&tStruct);
		thisTime = tStruct.time + (((double)(tStruct.millitm)) / 1000.0);
		if(thisTime >= nextTime)
		{
			// Tell the mediator to update at TIMESTEP intervals
			hm->updateTime(curTime);
			// Update the current time

			curTime+=(0.016666666 * TIMESTEP);  // 0.016666666 hours = 1 minutes
			if(curTime >= (23.0 + (0.016666666 * TIMESTEP)))
				curTime = 0.0; // Set back to midnight
			// Set new next time for the timing loop
			nextTime = thisTime + 1.0; // Next time is 1 second from now or 5 minutes sim time 
		}
	}
}

// In this demonstration of the mediator we will call from main() a special 
//   function in the HomeMediator which will update the timer in each 
//   appliance.  In a real implementation of the mediator each appliance, 
//   if appropriate, would keep its own time or other sensor in order to
//   know when to call the mediator to handle it's event.