//=========================================================
// HomeMediator.h
// This class defines the mediator to interface between all
//   of the appliances in the Mediator Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#ifndef HOMEMEDIATOR_H
#define HOMEMEDIATOR_H

#include "Appliance.h"

#define NUM_APPLIANCES	4


class HomeMediator
{
	public:
		enum Appliances { ALARMCLOCK, CALENDAR, SPRINKLER, COFFEEPOT};
	private:
		Appliance *m_TheAppliances[NUM_APPLIANCES];		// Just using 4 appliances in this demo
		char *m_sMessage;

	public:
    HomeMediator();									   // Constructor
    ~HomeMediator();								   // Destructor
	void updateTime(double time);					   // Update the current sim time.
    void handleEvent(int appIndex);					   // Appliance or other trigger calls here
    void ApplianceHasMessage(Appliance *theAppliance); // Appliance calls here with message to dispatch
};

#endif
