//=========================================================
// HomeMediator.cpp
// This class defines the mediator to interface between all
//   of the appliances in the Mediator Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#pragma warning(disable:4996)

#include "HomeMediator.h"
#include "AlarmClock.h"
#include "Calendar.h"
#include "Sprinkler.h"
#include "CoffeePot.h"

#include <iostream>
using namespace std;

//-------------------------------------------
// Constructor
//-------------------------------------------
HomeMediator::HomeMediator()
{
    m_TheAppliances[ALARMCLOCK] = new AlarmClock(this, "AlarmClock");
    m_TheAppliances[CALENDAR] = new Calendar(this, "Calendar");
    m_TheAppliances[SPRINKLER] = new Sprinkler(this, "Sprinkler");
    m_TheAppliances[COFFEEPOT] = new CoffeePot(this, "CoffeePot");
}

//-------------------------------------------
// Destructor
//-------------------------------------------
HomeMediator::~HomeMediator()
{
  for (int i = 0; i < NUM_APPLIANCES; i++)
	delete m_TheAppliances[i];
}

//-------------------------------------------
// Update the current sim time.
//-------------------------------------------
void HomeMediator::updateTime(double time)
{
	// For this demonstration we will also update the time
	//   in each appliance.  In a real application of the
	//   mediator each appliance would keep its own time
	//   and know when to respond.
	for(int i=0; i<NUM_APPLIANCES; i++)
	{
		m_TheAppliances[i]->updateTime(time);
	}
	cout << endl;
}

//-------------------------------------------
// Respond to an appliance with a message.
//-------------------------------------------
void HomeMediator::ApplianceHasMessage(Appliance *theAppliance)
{
    if (theAppliance == m_TheAppliances[ALARMCLOCK])
    {
        m_sMessage = m_TheAppliances[ALARMCLOCK]->queryAppliance();
		if(m_sMessage != NULL)
		{
			cout << "Message from " << m_TheAppliances[ALARMCLOCK]->getName();
			cout << "\t\t" << m_sMessage << endl; // Output time message
			// Pass the message on to the others
			m_TheAppliances[CALENDAR]->updateAppliance(m_sMessage);
			m_TheAppliances[SPRINKLER]->updateAppliance(m_sMessage);
			m_TheAppliances[COFFEEPOT]->updateAppliance(m_sMessage);
		}
    }
    else if (theAppliance == m_TheAppliances[CALENDAR])
    {
        m_sMessage = m_TheAppliances[CALENDAR]->queryAppliance();
		if(m_sMessage != NULL)
		{
			cout << "Message from " << m_TheAppliances[CALENDAR]->getName();
			cout << "\t\t" << m_sMessage << endl; // Output time message
			// Pass the message on to the others
			m_TheAppliances[ALARMCLOCK]->updateAppliance(m_sMessage);
			m_TheAppliances[SPRINKLER]->updateAppliance(m_sMessage);
			m_TheAppliances[COFFEEPOT]->updateAppliance(m_sMessage);
		}
    }
    else if (theAppliance == m_TheAppliances[SPRINKLER])
    {
        m_sMessage = m_TheAppliances[SPRINKLER]->queryAppliance();
		if(m_sMessage != NULL)
		{
			cout << "Message from " << m_TheAppliances[SPRINKLER]->getName();
			cout << "\t\t" << m_sMessage << endl; // Output time message
			// Pass the message on to the others
			m_TheAppliances[CALENDAR]->updateAppliance(m_sMessage);
			m_TheAppliances[ALARMCLOCK]->updateAppliance(m_sMessage);
			m_TheAppliances[COFFEEPOT]->updateAppliance(m_sMessage);
		}
   }
    else if (theAppliance == m_TheAppliances[COFFEEPOT])
    {
        m_sMessage = m_TheAppliances[COFFEEPOT]->queryAppliance();
		if(m_sMessage != NULL)
		{
			cout << "Message from " << m_TheAppliances[COFFEEPOT]->getName();
			cout << "\t\t" << m_sMessage << endl; // Output time message
			// Pass the message on to the others
			m_TheAppliances[CALENDAR]->updateAppliance(m_sMessage);
			m_TheAppliances[ALARMCLOCK]->updateAppliance(m_sMessage);
			m_TheAppliances[SPRINKLER]->updateAppliance(m_sMessage);
		}
    }
}
