//=========================================================
// CoffeePot.cpp
// This class defines a sub-class of CoffeePot for the 
//	Mediator Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#pragma warning(disable:4996)

#include "CoffeePot.h"
#include "HomeMediator.h"
#include <string.h>
#include <iostream>
using namespace std;

//----------------------------------
// Constructor
//----------------------------------
CoffeePot::CoffeePot(HomeMediator *mediator, char *name)
{
	m_TheMediator = mediator; // Set pointer to the mediator
	strcpy(m_sName, name);    // Save the CoffeePot name
	m_dTime = 0.0;			  // Start at midnight
}

//----------------------------------
// Destructor
//----------------------------------
CoffeePot::~CoffeePot()
{
	// Nothing to do.  Someone else destroys the mediator
}

//----------------------------------------------------
// Check to see if we need to send a message to the
//   mediator.
//----------------------------------------------------
void CoffeePot::checkStatus()
{
	// Nothing to do here we check on time/day messages
	//  relayed by the mediator from the clock and calendar
}

//----------------------------------------------------
// Pass a message to the mediator when it calls. This
//   message will be relayed to the other CoffeePots.
//----------------------------------------------------
char *CoffeePot::queryAppliance()
{
	int roundTime = (int)((m_dTime+0.05) * 10);
	if((roundTime >= 60) && (roundTime < 65))
	{
		sprintf(m_sMessage, "COFFEEPOT: Starting to brew morning coffee.");
	}
	else if((roundTime >= 65) && (roundTime < 70))
	{
		sprintf(m_sMessage, "COFFEEPOT: Morning coffee is ready.");
	}
	else if((roundTime >= 170) && (roundTime < 175))
	{
		sprintf(m_sMessage, "COFFEEPOT: Starting to brew evening coffee.");
	}
	else if((roundTime >= 175) && (roundTime < 180))
	{
		sprintf(m_sMessage, "COFFEEPOT: Evening coffee is ready.");
	}
	return m_sMessage;
}

//----------------------------------------------------
// Mediator calls this function to pass in a message 
//  from the other appliances.
//----------------------------------------------------
void CoffeePot::updateAppliance(char *msg)
{
	// See if the message is a coffee pot on/off time.
	// The user in this simulation is assumed to be a
	//   big coffee drinker so he has the coffee pot 
	//   brew him a pot twice a day, every day

	if((strstr(msg, "DAY") != NULL))  // Make sure this is a time messag not calendar
	{
		int roundTime = (int)((m_dTime+0.05) * 10);
		// Start brewing at 6:30 and 17:30 (5:30 pm) end 30 minutes later
		// Note: The way the cycle runs the actual time here will
		//		always be one TIMESTEP behind the AlarmClock
		if(((roundTime >= 60) && (roundTime <= 65)) ||
			((roundTime >= 170) && (roundTime <= 175)))
		{
			m_TheMediator->ApplianceHasMessage(this); // Tell the mediator we have a message
		}
	}
}
