//=========================================================
// Calendar.h
// This class defines a sub-class of Appliance for the 
//	Mediator Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#ifndef CALENDAR_H
#define CALENDAR_H

#include "Appliance.h"

class Calendar : public Appliance
{
	private:
		int m_iDayOfWeek;

	public:
		Calendar(HomeMediator *mediator, char *name);	// Constructor
		~Calendar();									// Destructor
		void checkStatus();					// Check for need to send a message to the mediator
		char *queryAppliance();				// Pass a message to the mediator for other appliances
		void updateAppliance(char *msg);    // Get update message from the mediator
};

#endif