//=========================================================
// Calendar.cpp
// This class defines a sub-class of Calendar for the 
//	Mediator Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#pragma warning(disable:4996)

#include "Calendar.h"
#include "HomeMediator.h"
#include <string.h>
#include <iostream>
using namespace std;

//----------------------------------
// Constructor
//----------------------------------
Calendar::Calendar(HomeMediator *mediator, char *name)
{
	m_TheMediator = mediator; // Set pointer to the mediator
	strcpy(m_sName, name);    // Save the Calendar name
	m_dTime = 0.0;			  // Start at midnight
//	m_iDayOfWeek = 7;		  // Start with Saturday, on init this will become Sunday
	m_iDayOfWeek = 1;		  // Start with Sunday for testing sprinkler
}

//----------------------------------
// Destructor
//----------------------------------
Calendar::~Calendar()
{
	// Nothing to do.  Someone else destroys the mediator
}

//----------------------------------------------------
// Check to see if we need to send a message to the
//   mediator.
//----------------------------------------------------
void Calendar::checkStatus()
{
	// Check to see if it is time to roll over the day
	if(m_dTime == 0.0)
	{
		m_iDayOfWeek++;
		if(m_iDayOfWeek > 7)
			m_iDayOfWeek = 1; // Go back to Sunday
//		m_TheMediator->ApplianceHasMessage(this); // Tell the mediator we have a message
	}
}

//----------------------------------------------------
// Pass a message to the mediator when it calls. This
//   message will be relayed to the other Calendars.
//----------------------------------------------------
char *Calendar::queryAppliance()
{
	switch(m_iDayOfWeek)
	{
		case 1 :	// Sunday
			sprintf(m_sMessage, "DAY: Sunday");
			break;
		case 2 :	// Monday
			sprintf(m_sMessage, "DAY: Monday");
			break;
		case 3 :	// Tuesday
			sprintf(m_sMessage, "DAY: Tuesday");
			break;
		case 4 :	// Wednesday
			sprintf(m_sMessage, "DAY: Wednesday");
			break;
		case 5 :	// Thursday
			sprintf(m_sMessage, "DAY: Thursday");
			break;
		case 6 :	// Friday
			sprintf(m_sMessage, "DAY: Friday");
			break;
		case 7 :	// Saturday
			sprintf(m_sMessage, "DAY: Saturday");
			break;
	}
	return m_sMessage;
}

//----------------------------------------------------
// Mediator calls this function to pass in a message 
//  from the other appliances.
//----------------------------------------------------
void Calendar::updateAppliance(char *msg)
{
	// See if the message is a time.  If so reply back with the date
	if(strstr(msg, "TIME") != NULL)
	{
		m_TheMediator->ApplianceHasMessage(this); // Tell the mediator we have a message
	}
}
