//=========================================================
// Appliance.h
// This class defines the parent class for all sub-classes
//   of appliances in the Mediator Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#ifndef APPLIANCE_H
#define APPLIANCE_H

class HomeMediator; // forward reference to avoid circular include
//#include "HomeMediator.h"

class Appliance
{
  protected:
    char m_sName[20];			// Name of this appliance
	double m_dTime;				// current time
	char m_sMessage[128];		// Char array to hold messages to pass
    HomeMediator *m_TheMediator;// The mediator

public:
	Appliance();								    // Default constructor
    Appliance(HomeMediator *mediator, char *name);	// Constructor
	~Appliance();									// Destructor
	char *getName();							// Return the name of this appliance
	void updateTime(double time);				// Set the time.  This is just for this demonstration
    virtual void checkStatus();					// Check for need to send a message to the mediator
    virtual char *queryAppliance();				// Pass a message to the mediator for other appliances
    virtual void updateAppliance(char *msg);    // Get update message from the mediator
};

#endif