//=========================================================
// Appliance.cpp
// This class defines the parent class for all sub-classes
//   of appliances in the Mediator Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#pragma warning(disable:4996)

#include "Appliance.h"
#include "HomeMediator.h"
#include <string.h>
#include <iostream>
using namespace std;

//----------------------------------
// Default constructor-Not used
//----------------------------------
Appliance::Appliance()
{
}

//----------------------------------
// Constructor
//----------------------------------
Appliance::Appliance(HomeMediator *mediator, char *name)
{
	m_TheMediator = mediator; // Set pointer to the mediator
	strcpy(m_sName, name);    // Save the appliance name
	m_dTime = 0.0;			  // Start at midnight
}

//----------------------------------
// Destructor
//----------------------------------
Appliance::~Appliance()
{
	// Nothing to do.  Someone else destroys the mediator
}

//----------------------------------------------------
// Return the name of this appliance
//----------------------------------------------------
char *Appliance::getName()
{
	return m_sName;
}

//----------------------------------------------------
// Set the time.  This is just for this demonstration. 
//   In a real implementation of the mediator each 
//   appliance would keep its own time or other sensor 
//   in order to know when to call the mediator to 
//   handle it's events.
//----------------------------------------------------
void Appliance::updateTime(double time)
{
	m_dTime = time;
	checkStatus();  
}

//----------------------------------------------------
// Check to see if we need to send a message to the
//   mediator.
//----------------------------------------------------
void Appliance::checkStatus()
{
}

//----------------------------------------------------
// Pass a message to the mediator when it calls. This
//   message will be relayed to the other appliances.
//----------------------------------------------------
char *Appliance::queryAppliance()
{
	return NULL;
}

//----------------------------------------------------
// Mediator calls this function to pass in a message 
//  from the other appliances.
//----------------------------------------------------
void Appliance::updateAppliance(char *msg)
{
}
