//=========================================================
// AlarmClock.h
// This class defines a sub-class of AlarmClock for the 
//	Mediator Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#pragma warning(disable:4996)

#include "AlarmClock.h"
#include "HomeMediator.h"
#include <string.h>
#include <iostream>
using namespace std;

//----------------------------------
// Constructor
//----------------------------------
AlarmClock::AlarmClock(HomeMediator *mediator, char *name)
{
	m_TheMediator = mediator; // Set pointer to the mediator
	strcpy(m_sName, name);    // Save the AlarmClock name
	m_dTime = 0.0;			  // Start at midnight
}

//----------------------------------
// Destructor
//----------------------------------
AlarmClock::~AlarmClock()
{
	// Nothing to do.  Someone else destroys the mediator
}

//----------------------------------------------------
// Check to see if we need to send a message to the
//   mediator. This function gets called every second
//   (5 minutes sim time) by the upDate function
//   inherited from the parent class Appliance.
//----------------------------------------------------
void AlarmClock::checkStatus()
{
	// Every time interval let's tell the mediator we have a message to send
	m_TheMediator->ApplianceHasMessage(this);
}

//----------------------------------------------------
// Pass a message to the mediator when it calls. This
//   message will be relayed to the other AlarmClocks.
//----------------------------------------------------
char *AlarmClock::queryAppliance()
{
	int hr;
	int min;
	hr = (int)m_dTime;   // Get the hours
	min = (int)((m_dTime - hr) * 60.0 + 0.5); // Convert fraction to minutes and round
	if(min == 60)
	{
		hr++;
		min = 0;
	}
	if(min < 10)
		sprintf(m_sMessage, "TIME: %d:0%d", hr, min);
	else
		sprintf(m_sMessage, "TIME: %d:%d", hr, min);
	return m_sMessage;
}

//----------------------------------------------------
// Mediator calls this function to pass in a message 
//  from the other appliances.
//----------------------------------------------------
void AlarmClock::updateAppliance(char *msg)
{
}
