//=========================================================
// RNInterpreter.h
// This class defines the parent class for all sub-classes
//   of interpreter in the Interpreter Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#ifndef RNINTERPRETER_H
#define RNINTERPRETER_H

class RNInterpreter
{
  private:
    RNInterpreter *thousands;
    RNInterpreter *hundreds;
    RNInterpreter *tens;
    RNInterpreter *ones;

  protected:
    virtual char one();    // Return single character if one of, i.e. I, X, L, C, M
    virtual char *four();  // Return 2 char array if one unit before 5 of, i.e. IV, XL, XC, CD, CM
    virtual char five();   // Return single character if five of, i.e. V, L, D, M
    virtual char *nine();  // Return 2 char array if one unit before 10 of, i.e. IX, XC, CM
    virtual int multiplier(); // Place multiplier for this unit, i.e. 1, 10, 100, 1000

  public:
    RNInterpreter();					// Default constructor
    ~RNInterpreter();					// Destructor
	void createInterpreters();			// Only parent class uses this
    int interpret(char* input);			// interpret() for client
    virtual void interpret(char *input, int &total);
};

#endif
