//=========================================================
// RNInterpreter.cpp
// This class defines the parent class for all sub-classes
//   of interpreter in the Interpreter Design Pattern 
// Author: Dr. Rick Coleman
//=========================================================
#include "RNInterpreter.h"
#include "RNOneInterpreter.h"
#include "RNTenInterpreter.h"
#include "RNHundredInterpreter.h"
#include "RNThousandInterpreter.h"
#include <string.h>
#include <iostream>
using namespace std;

//-----------------------------------------------------
// Default constructor
//-----------------------------------------------------
RNInterpreter::RNInterpreter()
{
}

//-----------------------------------------------------
// Destructor
//-----------------------------------------------------
RNInterpreter::~RNInterpreter()
{
}

//-----------------------------------------------------
// Only parent class uses this to create instances
//	of all the interpreters
//-----------------------------------------------------
void RNInterpreter::createInterpreters()
{
	thousands = new RNThousandInterpreter();
	hundreds = new RNHundredInterpreter();
	tens = new RNTenInterpreter();
	ones = new RNOneInterpreter();
}

//-----------------------------------------------------
// interpret() for client
//-----------------------------------------------------
int RNInterpreter::interpret(char* input)
{
	int total;
	total = 0;
	thousands->interpret(input, total);
	hundreds->interpret(input, total);
	tens->interpret(input, total);
	ones->interpret(input, total);
	if (strcmp(input, "")) // if input was invalid, return 0
		return 0;
	return total;
}

//-----------------------------------------------------
// interpret function which all sub-classes must
//   override.
//-----------------------------------------------------
void RNInterpreter::interpret(char *input, int &total)
{
        // for internal use
        int index;
        index = 0;
        if (!strncmp(input, nine(), 2))
        {
            total += 9 * multiplier();
            index += 2;
        }
        else if (!strncmp(input, four(), 2))
        {
            total += 4 * multiplier();
            index += 2;
        }
        else
        {
            if (input[0] == five())
            {
                total += 5 * multiplier();
                index = 1;
            }
            else
              index = 0;
            for (int end = index + 3; index < end; index++)
              if (input[index] == one())
                total += 1 * multiplier();
              else
                break;
        }
        strcpy(input, &(input[index]));
}

//--------------------------------------------------------
// Return single character if one of, i.e. I, X, L, C, M
//--------------------------------------------------------
char RNInterpreter::one()
{
	return ' ';
}

//-----------------------------------------------------
// Return 2 char array if one unit before 5 of, 
//	i.e. IV, XL, XC, CD, CM
//-----------------------------------------------------
char *RNInterpreter::four()
{
	return "";
}

//-----------------------------------------------------
// Return single character if five of, i.e. V, L, D, M
//-----------------------------------------------------
char RNInterpreter::five()
{
	return ' ';
}

//-----------------------------------------------------
// Return 2 char array if one unit before 10 of, 
//	i.e. IX, XC, CM
//-----------------------------------------------------
char *RNInterpreter::nine()
{
	return "";
}

//-------------------------------------------------------
// Place multiplier for this unit, i.e. 1, 10, 100, 1000
//-------------------------------------------------------
int RNInterpreter::multiplier()
{
	return 0;
}

