//===========================================================
// RNHundredInterpreter.cpp
// This class defines the sub-class for interpreting
//   hundred units of the current radix in the Interpreter 
//	 Design Pattern.
// Author: Dr. Rick Coleman
//===========================================================
#include "RNHundredInterpreter.h"

//-------------------------------------
// Parameterized constructor
//-------------------------------------
RNHundredInterpreter::RNHundredInterpreter()
{
}

//-------------------------------------
// Destructor
//-------------------------------------
RNHundredInterpreter::~RNHundredInterpreter()
{
}

//-------------------------------------
// Return single character if one unit, 
//	i.e. I, X, L, C, M
//-------------------------------------
char RNHundredInterpreter::one()
{
    return 'C';
}
//----------------------------------------
// Return 2 char array if one unit 
//	before 5 of, i.e. IV, XL, XC, CD, CM
//----------------------------------------
char *RNHundredInterpreter::four()
{
    return "CD";
}
//-------------------------------------
// Return single character if five of, 
//	i.e. V, L, D, M
//-------------------------------------
char RNHundredInterpreter::five()
{
    return 'D';
}
//-------------------------------------
// Return 2 char array if one unit 
//	before 10 of, i.e. IX, XC, CM
//-------------------------------------
char *RNHundredInterpreter::nine()
{
    return "CM";
}
//-------------------------------------
// Place multiplier for this unit, 
//	i.e. 1, 10, 100, 1000
//-------------------------------------
int RNHundredInterpreter::multiplier()
{
    return 100;
}
