//=====================================================
// TreeManager.h
// This class defines a tree manager object to serve
//	as the flyweight manager object to demonstrate the 
//  Flyweight Design Pattern 
// Author: Dr. Rick Coleman
//=====================================================
#ifndef TREEMANAGER_H
#define TREEMANAGER_H

#include "Tree.h"

#define MAXTREES 100

class TreeManager
{
	private:
		int m_treeArray[MAXTREES][3]; // Array defining specs for all trees
		Tree *m_TheTree;			  // Flyweight tree

	public:
		TreeManager();							// Default Constructor
		~TreeManager();							// Destructor
		void displayTrees();					// Display all the trees
};

#endif