//=====================================================
// TreeManager.cpp
// This class defines a tree manager object to serve
//	as the flyweight manager object to demonstrate the 
//  Flyweight Design Pattern 
// Author: Dr. Rick Coleman
//=====================================================
#include "TreeManager.h"
#include <stdlib.h>
#include <sys/types.h>     // needed for the _ftime() function
#include <sys/timeb.h>     // contains definition of _timeb struct
#include <time.h>          // needed for other time functions and structures

//------------------------------------
// Default Constructor - this function
//   creates all the trees
//------------------------------------
TreeManager::TreeManager()
{
	int row;
	int col;
	int age;

	// Seed the random number generator
	srand((unsigned int)(time(NULL)));
	// Create the single tree to represent all in the flyweighty
	m_TheTree = new Tree();
	// Generate a random number of trees
	// If two happen to hit the same row/column then only the last will be used
	int numTrees = rand() % MAXTREES;
	for(int i=0; i<numTrees; i++)
	{
		row = rand() % DIMENSION; // DIMENSION is defined in Tree.h
		col = rand() % DIMENSION;
		age = rand() % 150;		  // Create trees in the range 0..150 years
		m_TheTree->display(row, col, age); // Add this tree to the display
	}
}

//------------------------------------
// Destructor
//------------------------------------
TreeManager::~TreeManager()
{
	if(m_TheTree != NULL)
		delete m_TheTree;
}

//------------------------------------
// Display all the trees
//------------------------------------
void TreeManager::displayTrees()
{
	m_TheTree->showLandScape();
}