//=====================================================
// Tree.cpp
// This class defines a single tree object to serve
//	as the flyweight object to demonstrate the 
//  Flyweight Design Pattern 
// Author: Dr. Rick Coleman
//=====================================================
#include "Tree.h"
#include <iostream>
using namespace std;

//---------------------------------------
// Default Constructor
//---------------------------------------
Tree::Tree()
{
	// Init all grid locations to empty
	for(int row=0; row<DIMENSION; row++)
		for(int col=0; col<DIMENSION; col++)
			m_LandScape[row][col] = ' ';
}

//---------------------------------------
// Destructor
//---------------------------------------
Tree::~Tree()
{
}

//---------------------------------------
// Draw a tree with the given specs
// Args: x = row (0..DIMENSION)
//       Y = column (0..DIMENSION)
//       age = int value to indicate size
//			of the tree.
//---------------------------------------
void Tree::display(int x, int y, int age)
{
	// Trees aged (0-25) display as ASCII F9 (249)
	// Trees aged (26-50) display as ASCII FE (254)
	// Trees aged (51-75) display as ASCII B0 (176)
	// Trees aged (76-100) display as ASCII B1 (177)
	// Trees aged (>100) display as ASCII B2 (178)
	if((x < 0) || (x > DIMENSION))
		cout << "Invalid row dimension. Input ignored.\n";
	else if((y < 0) || (y > DIMENSION))
		cout << "Invalid column dimension. Input ignored.\n";
	if(age <= 25)
		m_LandScape[x][y] = (char)249;
	else if((age > 25) && (age <= 50))
		m_LandScape[x][y] = (char)254;
	else if((age > 50) && (age <= 75))
		m_LandScape[x][y] = (char)176;
	else if((age > 75) && (age <= 100))
		m_LandScape[x][y] = (char)177;
	else
		m_LandScape[x][y] = (char)178;
}

//---------------------------------------
// Print the array
//---------------------------------------
void Tree::showLandScape()
{
	// Print the diagram
	cout << "\n=== Diagram representing the landscaping layout ===\n";
	for(int row=0; row<DIMENSION; row++)
	{
		for(int col=0; col<DIMENSION; col++)
		{
			cout << m_LandScape[row][col];
		}
		// Newline at end of line
		cout << endl;
	}
	cout << "===================================================\n";
	cout << "Trees aged (0-25) display as: " << (char)(249) << endl;
	cout << "Trees aged (26-50) display as: " << (char)(254) << endl;
	cout << "Trees aged (51-75) display as: " << (char)(176) << endl;
	cout << "Trees aged (76-100) display as: " << (char)(177) << endl;
	cout << "Trees aged (>100) display as: " << (char)(178) << endl;
	cout << endl << endl;
}

