//=====================================================
// UnknownHandler.h
// This class is a sub-class for the UnknownHandler 
//		to demonstrate the Chain Of Responsibility
//		Design 
// Author: Dr. Rick Coleman
//=====================================================
#include "UnknownHandler.h"
#include <iostream>
using namespace std;

//------------------------------------
// Constructor
//------------------------------------
UnknownHandler::UnknownHandler()
{
	m_Successor = NULL;
}

//------------------------------------
// Destructor
//------------------------------------
UnknownHandler::~UnknownHandler()
{
	// Let each UnknownHandler delete its successor in the chain
	delete m_Successor;
}

//------------------------------------
// Handle this message
//------------------------------------
void UnknownHandler::handleRequest(E_Mail *msg)
{
	if(msg->getType() == UNKNOWN)	// Handle this message
	{
		cout << "??? Unknown Handler ???\n";
		cout << "\tFrom: " << msg->getFromAddr() << endl;
		cout << "\tTo: " << msg->getToAddr() << endl;
		cout << "\tMessage: " << msg->getMessage() << endl;
		cout << "\tReply: There is no handler for this message type.\n\n";
	}
	else if(this->m_Successor != NULL)// Pass the message on to the succesor
	{
		m_Successor->handleRequest(msg);
	}
	else
		cout << "There is no successor handler for the Unknown Handler.\n";
}
