//=====================================================
// SpamHandler.h
// This class is a sub-class for the SpamHandler 
//		to demonstrate the Chain Of Responsibility
//		Design 
// Author: Dr. Rick Coleman
//=====================================================
#include "SpamHandler.h"
#include <iostream>
using namespace std;

//------------------------------------
// Constructor
//------------------------------------
SpamHandler::SpamHandler()
{
	m_Successor = NULL;
}

//------------------------------------
// Destructor
//------------------------------------
SpamHandler::~SpamHandler()
{
	// Let each SpamHandler delete its successor in the chain
	delete m_Successor;
}

//------------------------------------
// Handle this message
//------------------------------------
void SpamHandler::handleRequest(E_Mail *msg)
{
	if(msg->getType() == SPAM)	// Handle this message
	{
		cout << "!!! Spam Handler !!!\n";
		cout << "\tFrom: " << msg->getFromAddr() << endl;
		cout << "\tTo: " << msg->getToAddr() << endl;
		cout << "\tMessage: " << msg->getMessage() << endl;
		cout << "\tReply: Whatever you are selling. We aren't interested.\n\n";
	}
	else if(this->m_Successor != NULL)// Pass the message on to the succesor
	{
		m_Successor->handleRequest(msg);
	}
	else
		cout << "There is no successor handler for the Spam Handler.\n";
}
