//=====================================================
// NewFeatureHandler.h
// This class is a sub-class for the NewFeatureHandler 
//		to demonstrate the Chain Of Responsibility
//		Design 
// Author: Dr. Rick Coleman
//=====================================================
#include "NewFeatureHandler.h"
#include <iostream>
using namespace std;

//------------------------------------
// Constructor
//------------------------------------
NewFeatureHandler::NewFeatureHandler()
{
	m_Successor = NULL;
}

//------------------------------------
// Destructor
//------------------------------------
NewFeatureHandler::~NewFeatureHandler()
{
	// Let each NewFeatureHandler delete its successor in the chain
	delete m_Successor;
}

//------------------------------------
// Handle this message
//------------------------------------
void NewFeatureHandler::handleRequest(E_Mail *msg)
{
	if(msg->getType() == NEWFEATURE)	// Handle this message
	{
		cout << "*** NewFeature Handler ***\n";
		cout << "\tFrom: " << msg->getFromAddr() << endl;
		cout << "\tTo: " << msg->getToAddr() << endl;
		cout << "\tMessage: " << msg->getMessage() << endl;
		cout << "\tReply: That is an excellent idea. We'll pass it on to the developers.\n\n";
	}
	else if(this->m_Successor != NULL)// Pass the message on to the succesor
	{
		m_Successor->handleRequest(msg);
	}
	else
		cout << "There is no successor handler for the NewFeature Handler.\n";
}
