//=====================================================
// Handler.h
// This class is the parent class for all handlers 
//		to demonstrate the Chain Of Responsibility
//		Design 
// Author: Dr. Rick Coleman
//=====================================================
#ifndef HANDLER_H
#define HANDLER_H

#include "E_Mail.h"

class Handler
{
	protected:
		Handler *m_Successor;		// Next handler in the chain

	public:
		Handler();					// Constructor
		~Handler();					// Destructor
		void setSuccessor(Handler *s);				// Set the sucessor handler
		virtual void handleRequest(E_Mail *msg);	// Handle this message
};

#endif