//=====================================================
// Handler.cpp
// This class is the parent class for all handlers 
//		to demonstrate the Chain Of Responsibility
//		Design 
// Author: Dr. Rick Coleman
//=====================================================
#include "Handler.h"
#include <iostream>
using namespace std;

//------------------------------------
// Constructor
//------------------------------------
Handler::Handler()
{
	m_Successor = NULL;
}

//------------------------------------
// Destructor
//------------------------------------
Handler::~Handler()
{
	// Let each Handler delete its successor in the chain
	delete m_Successor;
}

//------------------------------------
// Set the sucessor handler
//------------------------------------
void Handler::setSuccessor(Handler *s)
{
	m_Successor = s;
}

//------------------------------------
// Handle this message
//------------------------------------
void Handler::handleRequest(E_Mail *msg)
{
}

