//=====================================================
// FanHandler.h
// This class is a sub-class for the FanHandler 
//		to demonstrate the Chain Of Responsibility
//		Design 
// Author: Dr. Rick Coleman
//=====================================================
#include "FanHandler.h"
#include <iostream>
using namespace std;

//------------------------------------
// Constructor
//------------------------------------
FanHandler::FanHandler()
{
	m_Successor = NULL;
}

//------------------------------------
// Destructor
//------------------------------------
FanHandler::~FanHandler()
{
	// Let each FanHandler delete its successor in the chain
	delete m_Successor;
}

//------------------------------------
// Handle this message
//------------------------------------
void FanHandler::handleRequest(E_Mail *msg)
{
	if(msg->getType() == FAN)	// Handle this message
	{
		cout << "+++ Fan Handler +++\n";
		cout << "\tFrom: " << msg->getFromAddr() << endl;
		cout << "\tTo: " << msg->getToAddr() << endl;
		cout << "\tMessage: " << msg->getMessage() << endl;
		cout << "\tReply: Thank you very much. We appreciate your support.\n\n";
	}
	else if(this->m_Successor != NULL)// Pass the message on to the succesor
	{
		m_Successor->handleRequest(msg);
	}
	else
		cout << "There is no successor handler for the Fan Handler.\n";
}
