//=====================================================
// E_Mail.h
// This class creates simulations of e-mail messages
//		to demonstrate the Chain Of Responsibility
//		Design Pattern
// Author: Dr. Rick Coleman
//=====================================================
#ifndef E_MAIL_H
#define E_MAIL_H

enum MESSAGETYPE {UNKNOWN, SPAM, FAN, COMPLAINT, NEWFEATURE};

class E_Mail
{
	private:
		char m_sFromAddr[32];
		char m_sToAddr[32];
		char m_sMessage[64];
		MESSAGETYPE m_Type;

	public:
		E_Mail();				// Constructor
		~E_Mail();				// Destructor
		MESSAGETYPE getType();	// Get the message type
		char *getFromAddr();	// Get the from address
		char *getToAddr();		// Get the to address
		char *getMessage();		// Get the message
};

#endif