//=====================================================
// E_Mail.cpp
// This class creates simulations of e-mail messages
//		to demonstrate the Chain Of Responsibility
//		Design 
// Author: Dr. Rick Coleman
//=====================================================
#include "E_Mail.h"
#include <stdlib.h>
#include <string.h>

//---------------------------------
// Constructor
//---------------------------------
E_Mail::E_Mail()
{
	// Randomly pick a message type
	int type = rand() % 5;
	switch(type)
	{
		case 0 : // Create an UNKNOWN message
			strcpy(m_sFromAddr, "WhoKnows@somewhere.net");
			strcpy(m_sToAddr, "COR_Inc@thisBusiness.com");
			strcpy(m_sMessage, "This is an unknown message.");
			m_Type = UNKNOWN;
			break;
		case 1 : // Create a SPAM message
			strcpy(m_sFromAddr, "Spammer@junkmail.org");
			strcpy(m_sToAddr, "COR_Inc@thisBusiness.com");
			strcpy(m_sMessage, "Do I have a deal on 10 cans of Spam for you!!!");
			m_Type = SPAM;
			break;
		case 2 : // Create a FAN message
			strcpy(m_sFromAddr, "FanAddict@somewhereoutthere.net");
			strcpy(m_sToAddr, "COR_Inc@thisBusiness.com");
			strcpy(m_sMessage, "I love your product.  When is version 2.0 coming out?");
			m_Type = FAN;
			break;
		case 3 : // Create a COMPLAINT message
			strcpy(m_sFromAddr, "Cranky@doihaveabitch.org");
			strcpy(m_sToAddr, "COR_Inc@thisBusiness.com");
			strcpy(m_sMessage, "Your product is a piece of garbage. Are you with MS?");
			m_Type = COMPLAINT;
			break;
		case 4 : // Create a NEWFEATURE message
			strcpy(m_sFromAddr, "Sug.Jester@ihaveanidea.net");
			strcpy(m_sToAddr, "COR_Inc@thisBusiness.com");
			strcpy(m_sMessage, "Do I have a great idea for you...");
			m_Type = NEWFEATURE;
			break;
	}
}

//---------------------------------
// Destructor
//---------------------------------
E_Mail::~E_Mail()
{
}

//---------------------------------
// Get the message type
//---------------------------------
MESSAGETYPE E_Mail::getType()
{
	return m_Type;
}

//---------------------------------
// Get the from address
//---------------------------------
char *E_Mail::getFromAddr()
{
	return m_sFromAddr;
}

//---------------------------------
// Get the to address
//---------------------------------
char *E_Mail::getToAddr()
{
	return m_sToAddr;
}

//---------------------------------
// Get the message
//---------------------------------
char *E_Mail::getMessage()
{
	return m_sMessage;
}
