//=====================================================
// ComplaintHandler.h
// This class is a sub-class for the ComplaintHandler 
//		to demonstrate the Chain Of Responsibility
//		Design 
// Author: Dr. Rick Coleman
//=====================================================
#include "ComplaintHandler.h"
#include <iostream>
using namespace std;

//------------------------------------
// Constructor
//------------------------------------
ComplaintHandler::ComplaintHandler()
{
	m_Successor = NULL;
}

//------------------------------------
// Destructor
//------------------------------------
ComplaintHandler::~ComplaintHandler()
{
	// Let each ComplaintHandler delete its successor in the chain
	delete m_Successor;
}

//------------------------------------
// Handle this message
//------------------------------------
void ComplaintHandler::handleRequest(E_Mail *msg)
{
	if(msg->getType() == COMPLAINT)	// Handle this message
	{
		cout << "--- Complaint Handler ---\n";
		cout << "\tFrom: " << msg->getFromAddr() << endl;
		cout << "\tTo: " << msg->getToAddr() << endl;
		cout << "\tMessage: " << msg->getMessage() << endl;
		cout << "\tReply: We are sorry you are having a problem. We will fix it.\n\n";
	}
	else if(this->m_Successor != NULL)// Pass the message on to the succesor
	{
		m_Successor->handleRequest(msg);
	}
	else
		cout << "There is no successor handler for the Complaint Handler.\n";
}
