//=============================================================
// ChainOfResponsibilityMain.cpp
// A demonstration of the Chain Of Responsibility design 
//		pattern in C++
// Author: Dr. Rick Coleman
//=============================================================
#include <iostream>
#include <stdlib.h>
#include <time.h> 

#include "E_Mail.h"
#include "Handler.h"
#include "SpamHandler.h"
#include "FanHandler.h"
#include "ComplaintHandler.h"
#include "NewFeatureHandler.h"
#include "UnknownHandler.h"
using namespace std;

void main()
{
	// Init the random number generator
	srand((unsigned int)(time(NULL)));
	// Create all the handlers
	Handler *handler1, *handler2, *handler3, *handler4, *handler5;
	handler1 = new SpamHandler();
	handler2 = new FanHandler();
	handler1->setSuccessor(handler2);
	handler3 = new ComplaintHandler();
	handler2->setSuccessor(handler3);
	handler4 = new NewFeatureHandler();
	handler3->setSuccessor(handler4);
	handler5 = new UnknownHandler();
	handler4->setSuccessor(handler5);
	
 	cout << "=== Demonstration of the Chain Of Responsibility Design Pattern ===\n\n";
	cout << "Creating 10 messages and passing them to the first handler...\n\n";
	for(int i=0; i<10; i++)
	{
		E_Mail *e = new E_Mail();
		handler1->handleRequest(e);
	}
}