//=============================================================
// SpicyPizzaBuilder.h
// A demonstration of the Builder Design Pattern.  This class
//   defines a sub-class of the SpicyPizzaBuilder. This is a 
//   concrete builder.
// Author: Dr. Rick Coleman
//=============================================================
#include "SpicyPizzaBuilder.h"

//---------------------------------
// Constructor
//---------------------------------
SpicyPizzaBuilder::SpicyPizzaBuilder()
{
	m_pThePizza = NULL;
}

//---------------------------------
// Destructor
//---------------------------------
SpicyPizzaBuilder::~SpicyPizzaBuilder()
{
}

//---------------------------------
// Get the pizza the builder just built
//---------------------------------
Pizza *SpicyPizzaBuilder::GetPizza()
{
	return m_pThePizza;
}

//---------------------------------
// Build the dough for the pizza
//---------------------------------
void SpicyPizzaBuilder::BuildDough()
{
	if(m_pThePizza == NULL)
		m_pThePizza = new Pizza();
	m_pThePizza->MakeDough("thick");
}

//---------------------------------
// Build the sauce for the pizza
//---------------------------------
void SpicyPizzaBuilder::BuildSauce()
{
	if(m_pThePizza == NULL)
		m_pThePizza = new Pizza();
	m_pThePizza->AddSauce("hot");
}

//---------------------------------
// Build the topping for the pizza
//---------------------------------
void SpicyPizzaBuilder::BuildTopping()
{
	if(m_pThePizza == NULL)
		m_pThePizza = new Pizza();
	m_pThePizza->AddTopping("pepperoni+salami");
}
