//=============================================================
// PizzaBuilder.h
// A demonstration of the Builder Design Pattern.  This class
//   defines the parent class of all Builders of the Pizzas.
//   This is the abstract builder.
// Author: Dr. Rick Coleman
//=============================================================
#ifndef PIZZABUILDER_H
#define PIZZABUILDER_H

#include "Pizza.h"

class PizzaBuilder 
{
	protected:
        Pizza *m_pThePizza;

	public:
		PizzaBuilder();						// Constructor
		~PizzaBuilder();					// Destructor
        Pizza *GetPizza();					// Get the pizza the builder just built
        virtual void BuildDough();			// Build the dough for the pizza
        virtual void BuildSauce();			// Build the sauce for the pizza
        virtual void BuildTopping();		// Build the topping for the pizza
};

#endif