//=============================================================
// PizzaBuilder.cpp
// A demonstration of the Builder Design Pattern.  This class
//   defines the parent class of all Builders of the Pizzas.
//   This is the abstract builder.
// Author: Dr. Rick Coleman
//=============================================================
#include "PizzaBuilder.h"

//---------------------------------
// Constructor
//---------------------------------
PizzaBuilder::PizzaBuilder()
{
	m_pThePizza = NULL;
}

//---------------------------------
// Destructor
//---------------------------------
PizzaBuilder::~PizzaBuilder()
{
}

//---------------------------------
// Get the pizza the builder just built
//---------------------------------
Pizza *PizzaBuilder::GetPizza()
{
	return m_pThePizza;
}

//---------------------------------
// Build the dough for the pizza
//---------------------------------
void PizzaBuilder::BuildDough()
{
}

//---------------------------------
// Build the sauce for the pizza
//---------------------------------
void PizzaBuilder::BuildSauce()
{
}

//---------------------------------
// Build the topping for the pizza
//---------------------------------
void PizzaBuilder::BuildTopping()
{
}
