//=============================================================
// Pizza.h
// A demonstration of the Builder Design Pattern.  This class
//   defines the all of the pizzas, i.e. the product to be
//   constructed by the Builder.
// Author: Dr. Rick Coleman
//=============================================================
#ifndef PIZZA_H
#define PIZZA_H

#include <string>
using namespace std;

class Pizza 
{
	private:
        char m_Dough[32];
        char m_Sauce[32];
        char m_Topping[32];

	public:
		Pizza();							// Constructor
		~Pizza();							// Destructor
        void MakeDough(char *dough);		// Make the dough for the pizza
        void AddSauce(char *sauce);			// Add the sauce to the pizza
        void AddTopping(char *topping);	// Add the topping to the pizza
        void OpenPizzaBox();				// Open the pizza box to get the pizza
};

#endif
