//=============================================================
// Pizza.cpp
// A demonstration of the Builder Design Pattern.  This class
//   defines the all of the pizzas, i.e. the product to be
//   constructed by the Builder.
// Author: Dr. Rick Coleman
//=============================================================
#include "Pizza.h"
#include <iostream>
using namespace std;

//---------------------------------
// Constructor
//---------------------------------
Pizza::Pizza()
{
}

//---------------------------------
// Destructor
//---------------------------------
Pizza::~Pizza()
{
}

//---------------------------------
// Make the dough for the pizza
//---------------------------------
void Pizza::MakeDough(char *dough) 
{
    strcpy(m_Dough, dough);
}

//---------------------------------
// Add the sauce to the pizza
//---------------------------------
void Pizza::AddSauce(char *sauce) 
{
    strcpy(m_Sauce, sauce);
}

//---------------------------------
// Add the topping to the pizza
//---------------------------------
void Pizza::AddTopping(char *topping) 
{
    strcpy(m_Topping, topping);
}

//------------------------------------
// Open the pizza box to get the pizza
//------------------------------------
void Pizza::OpenPizzaBox()
{
    cout << "\tHere's my pizza with " << m_Dough << " dough, " << m_Sauce << " sauce and "
            << m_Topping << " topping. " << endl << "\t\tYummmmmmmmm." << endl;
}
