//=============================================================
// HawaiianPizzaBuilder.h
// A demonstration of the Builder Design Pattern.  This class
//   defines a sub-class of the PizzaBuilder. This is a 
//   concrete builder.
// Author: Dr. Rick Coleman
//=============================================================
#ifndef HAWAIIANPIZZABUILDER_H
#define HAWAIIANPIZZABUILDER_H

#include "PizzaBuilder.h"

class HawaiianPizzaBuilder : public PizzaBuilder
{
	public:
		HawaiianPizzaBuilder();		// Constructor
		~HawaiianPizzaBuilder();	// Destructor
        Pizza *GetPizza();			// Get the pizza the builder just built
        void BuildDough();			// Build the dough for the pizza
        void BuildSauce();			// Build the sauce for the pizza
        void BuildTopping();		// Build the topping for the pizza
};

#endif