//=============================================================
// HawaiianPizzaBuilder.cpp
// A demonstration of the Builder Design Pattern.  This class
//   defines a sub-class of the HawaiianPizzaBuilder. This is a 
//   concrete builder.
// Author: Dr. Rick Coleman
//=============================================================
#include "HawaiianPizzaBuilder.h"
#include "Pizza.h"

//---------------------------------
// Constructor
//---------------------------------
HawaiianPizzaBuilder::HawaiianPizzaBuilder()
{
	m_pThePizza = NULL;
}

//---------------------------------
// Destructor
//---------------------------------
HawaiianPizzaBuilder::~HawaiianPizzaBuilder()
{
}

//---------------------------------
// Get the pizza the builder just built
//---------------------------------
Pizza *HawaiianPizzaBuilder::GetPizza()
{
	return m_pThePizza;
}

//---------------------------------
// Build the dough for the pizza
//---------------------------------
void HawaiianPizzaBuilder::BuildDough()
{
	if(m_pThePizza == NULL)
		m_pThePizza = new Pizza();
	m_pThePizza->MakeDough("thin");
}

//---------------------------------
// Build the sauce for the pizza
//---------------------------------
void HawaiianPizzaBuilder::BuildSauce()
{
	if(m_pThePizza == NULL)
		m_pThePizza = new Pizza();
	m_pThePizza->AddSauce("mild");
}

//---------------------------------
// Build the topping for the pizza
//---------------------------------
void HawaiianPizzaBuilder::BuildTopping()
{
	if(m_pThePizza == NULL)
		m_pThePizza = new Pizza();
	m_pThePizza->AddTopping("ham+pineapple");
}
