//=============================================================
// Cook.h
// A demonstration of the Builder Design Pattern.  This class
//   defines the class that uses different Builders to build
//   different products but does it through a common interface.
// Author: Dr. Rick Coleman
//=============================================================
#ifndef COOK_H
#define COOK_H

#include "PizzaBuilder.h"

class Cook
{
	private:
        PizzaBuilder *m_PizzaBuilder;

	public:
        Cook();					// Contructor
        ~Cook();				// Destructor
        void SetPizzaBuilder(PizzaBuilder* pizzaBuilder);  // Set the builder
        void ConstructPizza();	// Build the Pizza
        Pizza *GetPizza();		// Get the Pizza
};

#endif
