//=============================================================
// Cook.cpp
// A demonstration of the Builder Design Pattern.  This class
//   defines the class that uses different Builders to build
//   different products but does it through a common interface.
// Author: Dr. Rick Coleman
//=============================================================
#include "Cook.h"

//---------------------------------
// Constructor
//---------------------------------
Cook::Cook()
{ 
	m_PizzaBuilder = NULL;
}

//---------------------------------
// Destructor
//---------------------------------
Cook::~Cook() 
{
	if(m_PizzaBuilder != NULL)
		delete m_PizzaBuilder;
}

//---------------------------------
// Set the builder to use in 
//  building this product.
//---------------------------------
void Cook::SetPizzaBuilder(PizzaBuilder *pizzaBuilder) 
{
	// If we already have one delete it
    if(m_PizzaBuilder != NULL)
            delete m_PizzaBuilder;
	// Now set the builder
    m_PizzaBuilder = pizzaBuilder;
}

//---------------------------------
// Build the pizza.
//---------------------------------
void Cook::ConstructPizza() 
{
    m_PizzaBuilder->BuildDough();
    m_PizzaBuilder->BuildSauce();
    m_PizzaBuilder->BuildTopping();
}
//---------------------------------
// Return the pizza just built.
//---------------------------------
Pizza *Cook::GetPizza() 
{
    return m_PizzaBuilder->GetPizza();
}
