//=============================================================
// BuilderMain.cpp
// A demonstration of the Builder design pattern in C++
// Author: Dr. Rick Coleman
//=============================================================
#include <iostream>
using namespace std;
#include <stdio.h>
#include "Cook.h"
#include "Pizza.h"
#include "HawaiianPizzaBuilder.h"
#include "SpicyPizzaBuilder.h"

// SEE NOTES BELOW

void main()
{
 	cout << "=== Demonstration of the Builder Design Pattern ===\n\n";
	Cook cook;
	cout << "Giving the cook a HawaiianPizzaBuilder.\n";
	cook.SetPizzaBuilder(new HawaiianPizzaBuilder());
	cout << "Telling the cook to constructPizza().\n";
	cook.ConstructPizza();
	cout << "Telling the cook to getPizza().\n";
	Pizza *hawaiian = cook.GetPizza();
	cout << "Opening the pizza.\n";
	hawaiian->OpenPizzaBox();
	cout << endl << endl;

	cout << "Giving the cook a SpicyPizzaBuilder.\n";
	cook.SetPizzaBuilder(new SpicyPizzaBuilder());
	cout << "Telling the cook to constructPizza().\n";
	cook.ConstructPizza();
	cout << "Telling the cook to getPizza().\n";
	Pizza *spicy = cook.GetPizza();
	cout << "Opening the pizza.\n";
	spicy->OpenPizzaBox();

	cout << "\n\nPress enter to end this demonstation...";
	getchar();
}

// In this example we use a common interface in the Cook
//  class but give it different instances of subclasses
//  of PizzaBuilder depending on which type of pizza we
//  want.  The Cook can use the abstract PizzaBuilder
//  interface to build Pizzas of any type.  It is the
//  Builder that knows how to construct the desired type