//=============================================================
// ZuluTimeImp.cpp
// A demonstration of the Bridge Design Pattern.  This class
//   defines the parent class of the Implementation.
// Author: Dr. Rick Coleman
//=============================================================
#include "ZuluTimeImp.h"

//----------------------------
// Constructor
//----------------------------
ZuluTimeImp::ZuluTimeImp(int hr, int min, int zone) 
{
    m_iHr = hr;
	m_iMin = min;
    if(zone)
      strcpy(m_sZone, " Eastern Standard Time");
    else
      strcpy(m_sZone, " Central Standard Time");
	cout << "\tZuluTimeImp constructor set up for use.\n";
}

//----------------------------
// Destructor
//----------------------------
ZuluTimeImp::~ZuluTimeImp() 
{
}

//----------------------------
// Tell the time
//----------------------------
void ZuluTimeImp::tell() 
{
	cout << "\tZuluTimeImp gives the time as " << m_iHr << ":" << m_iMin << " " << m_sZone << endl;
}
